/*
 * fake library for ssh
 *
 * This file includes getnameinfo().
 * These funtions are defined in rfc2133.
 *
 * But these functions are not implemented correctly. The minimum subset
 * is implemented for ssh use only. For exapmle, this routine assumes
 * that ai_family is AF_INET. Don't use it for another purpose.
 */

#include "includes.h"
#include "ssh.h"

#ifndef HAVE_GETNAMEINFO
int getnameinfo(const struct sockaddr *sa, size_t salen, char *host, 
                size_t hostlen, char *serv, size_t servlen, int flags)
{
	struct sockaddr_in *sin = (struct sockaddr_in *)sa;
	struct hostent *hp;
	char tmpserv[16];

	if (serv) {
		snprintf(tmpserv, sizeof(tmpserv), "%d", ntohs(sin->sin_port));
		if (strlen(tmpserv) > servlen)
			return EAI_MEMORY;
		else
			strcpy(serv, tmpserv);
	}

	if (host) {
		if (flags & NI_NUMERICHOST) {
#ifdef _MINIX
			if (strlen(inet_ntoa(sin->sin_addr.s_addr)) > hostlen)
#else
			if (strlen(inet_ntoa(sin->sin_addr)) > hostlen)
#endif
				return EAI_MEMORY;
#ifdef _MINIX
			strcpy(host, inet_ntoa(sin->sin_addr.s_addr));
#else
			strcpy(host, inet_ntoa(sin->sin_addr));
#endif
			return 0;
		} else {
			hp = gethostbyaddr((char *)&sin->sin_addr, 
				sizeof(struct in_addr), AF_INET);
			if (hp == NULL)
				return EAI_NODATA;
			
			if (strlen(hp->h_name) > hostlen)
				return EAI_MEMORY;

			strcpy(host, hp->h_name);
			return 0;
		}
	}
	return 0;
}
#endif /* !HAVE_GETNAMEINFO */
